/**
* Script: items.js
* Written by: Radnen
* Updated: 1/16/2011
**/

// Weapon Types:
const GUN = 0;
const ROCKET = 1;

/**
* Item Object:
*  = holds base item properties.
**/
function Item(name, price, weight, rating) {
	this.name = name;
	this.price = price;
	this.weight = weight;
	this.rating = rating;
	
	this.equip = function(object) {
		if (object.cap.add(this.weight)) {
			object.rating += this.rating;
			return true;
		}
		else return false;
	}
	
	this.unequip = function(object) {
		object.cap.value -= this.weight;
		object.rating -= this.rating;
	}
}

/**
* Equipment Object:
*  = encapsulates an item object, used only in equipment slots.
**/
function Equip(item, amount) {
	if (!amount) amount = 0;
	
	this.item = item;
	this.amount = amount;
}

function Shield(name, rating, price, weight, mod, col) {
	this.inherit = Item;
	this.inherit(name, price, weight, rating);
	
	this.mod = mod;
	this.color = col;
	this.equip = function(object) {
		if (!object.cap.add(this.weight)) {
			return false;
		}
		else {
			object.shields.max = this.mod;
			if (object.shields.value > object.shields.max) object.shields.value = object.shields.max;
			object.shieldCol = Utility.copyColor(this.color);
			return true;
		}
	}
	
	this.unequip = function(object) {
		object.cap.value -= this.weight;
		object.shields.max = object.shields.value = 0;
	}
}

function Weapon(name, rating, price, weight, atk, cooldown, speed, life, emitter, sound, image, b_ai) {
	this.inherit = Item;
	this.inherit(name, price, weight, rating);
	
	this.atk = atk;
	this.image = image;
	this.cooldown = cooldown;
	this.sound = sound;
	this.life = life;
	this.emitter = emitter;
	this.spd = speed;
	this.type = GUN;
	
	this.fire = function(parent, offset) {
		Audio.playSound(Resources.sounds[this.sound]);
		var bullet = new Bullet(parent, offset);
		bullet.image = this.image;
		bullet.atk = this.atk;
		bullet.setSpeed(this.spd);
		bullet.life = this.life;
		if (b_ai) {
			bullet.ai_time = GetTime();
			bullet.ai = b_ai;
		}
		if (this.emitter) bullet.emitter = Utility.clone(Emitters[this.emitter]);
		Genesis.createBullet(bullet);
	};
}

function Rocket(name, rating, price, weight, atk, cooldown, speed, life, emitter, sound, image, endsound, b_ai) {
	this.inherit = Weapon;
	this.inherit(name, rating, price, weight, atk, cooldown, speed, life, emitter, sound, image);
	this.type = ROCKET;
	
	this.fire = function(parent) {
		Audio.playSound(Resources.sounds[this.sound]);
		var bullet = new Bullet(parent, 0);
		bullet.image = this.image;
		bullet.atk = this.atk;
		bullet.setSpeed(this.spd);
		bullet.life = this.life;
		if (b_ai) {
			bullet.ai_time = GetTime();
			bullet.ai = b_ai;
		}
		if (this.emitter) bullet.emitter = Utility.clone(Emitters[this.emitter]);
		bullet.onEnd = function() {
			Audio.playSound(Resources.sounds[endsound]);
		}
		Genesis.createBullet(bullet);
	}	
}

var Items = [];
Items[0]  = new Weapon("Mark I Laser"    , 1  , 500  , 15, 5 , 600 , 6 , 1000, null   , "minilaser", "laserbullet");
Items[1]  = new Weapon("Mark II Laser"   , 1.5, 10000, 20, 10, 500 , 8 , 1500, null   , "minilaser", "laserbullet2");
Items[2]  = new Weapon("Mark III Laser"  , 2  , 25000, 25, 15, 400 , 10, 2000, null   , "minilaser", "laserbullet3");
Items[3]  = new Weapon("Mining Laser I"  , 1  , 500  , 15, 2 , 150 , 7 , 800 , null   , "minilaser", "mininglaser");
Items[4]  = new Weapon("Mining Laser II" , 2  , 5000 , 25, 4 , 125 , 8 , 1200, null   , "minilaser", "mininglaser");
Items[5]  = new Rocket("X-5 Rockets"     , 2.5, 5000 , 3 , 20, 1000, 8 , 4000, "smoke", "rocket"   , "rocket"      , "explode");
Items[6]  = new Rocket("HeatSeek Rockets", 3  , 7500 , 4 , 30, 2000, 6 , 5000, "smoke", "rocket"   , "heatrocket"  , "explode", HeatSeek);
Items[7]  = new Shield("Shielding I"    , 1  , 2500  , 10   , 10, Colors.blue);
Items[8]  = new Shield("Shielding II"   , 1.5, 7500  , 10   , 15, Colors.green);
Items[9]  = new Shield("Shielding III"  , 2  , 10000 , 15   , 20, Colors.purple);
Items[10] = new Shield("Shielding IV"   , 2.5, 20000 , 15   , 25, Colors.red);
Items[11] = new Shield("Shielding V"    , 3  , 30000 , 20   , 30, Colors.yellow);